/*
 * Zip project folder and reveal zipped file in file system.
 * Provide progress report and allow abort
 */

File dir = rootFolder.file;
zipFile = null;

var queue = new MonitoredWorkQueue(window, "Zipping project folder");
queue.submit(() -> {
	zipFile = IO.zip(dir, (File f) -> {
		queue.message = f.name;
		if (queue.aborted) {
			throw new OperationAbortedException();
		}
		return true;
	});
});
queue.awaitCompletion();
if (zipFile) {
	MyDesktop.getDesktop().browseFileDirectory(zipFile);
}

